// RandomStick.java
package Alkindi.Services.ServicesImpl;

/* 
$Header: RandomStick.java, 10, 4/26/01 2:37:16 PM, Schwartz, Joe$
$Log: 
 10   Alkindi Development1.9         4/26/01 2:37:16 PM   Schwartz, Joe  
      Modifed to account for new InternalData package.
 9    Alkindi Development1.8         4/26/01 1:46:39 PM   Schwartz, Joe   Moved
      to new package.
 8    Alkindi Development1.7         12/28/00 1:07:28 PM  Schwartz, Joe   Added
      Version Control header info.
 7    Alkindi Development1.6         12/26/00 6:57:15 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/19/00 5:42:02 PM  Schwartz, Joe   
 5    Alkindi Development1.4         11/2/00 6:31:58 PM   Schwartz, Joe   
 4    Alkindi Development1.3         10/22/00 10:38:45 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 3    Alkindi Development1.2         10/17/00 2:22:49 PM  Schwartz, Joe  
      Delivery 10.16.00
 2    Alkindi Development1.1         10/7/00 4:34:33 PM   Schwartz, Joe   
 1    Alkindi Development1.0         10/7/00 4:29:10 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * 	A basic implementation of a random stick. Given a list of weights and a probability, this class figures out which weight pushes the total over the given probability. The methods are all declared as <b>static final</b> in order to speed processing.
 */
public class RandomStick 
{
	
	/**
	 * Given a list of weights, returns a random index to one of them. This routine computes the total of the weights, stopping when the total exceeds a random number generated internally. The return value is the index of the weight which pushed the total over the random number.
	 * 		@param w	the list of weights
	 * 		@return int
	 * @roseuid 3A3E9A340271
	 */
	public static final int chooseByWeights(double[] w) 
	{
		double TotalWeight = 0;
		double Stick = 0;
		double k = Math.random();
		int nn = 0;
		int i = 0;
		for (i=0; i < w.length; i++ )		{
			TotalWeight = TotalWeight+w[i];
		}

		for (nn=0; nn < w.length; nn++ )	{
			Stick = Stick+  (w[nn] / TotalWeight);
			if (k <= Stick){
				break;
			}
		}
		if (nn == w.length) nn --;
		return nn;
	}
	
	/**
	 * Randomly chooses between 0 and 1 based on the given weight.
	 * 		@param w the weight to use
	 * 		@return int
	 * @roseuid 3A3FA26A01E4
	 */
	public static final int chooseBinary(final double w) 
	{
		double p = Math.random();
		if (p<=w)
			return 0;
  		else
			return 1;
	}
}
